#ifndef _CREATETRIGGERS_CPP
#define _CREATETRIGGERS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"
#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Console.H"
#include "Replication.H"
#include "GetPKs.H"

#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/MainDlg.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool DropReplicationTriggers(CSQL *lpCSQL, char *sDB, char *sTable)
{
	WriteCon("DropReplicationTriggers\n");

	char sSQL[1024];

	sprintf(sSQL, "DROP TRIGGER [SQLExch_%s_%s_Update_Trigger]", sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	sprintf(sSQL, "DROP TRIGGER [SQLExch_%s_%s_Delete_Trigger]", sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool DropReplicationTables(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	WriteCon("DropReplicationTables\n");

	char sSQL[1024];

	sprintf(sSQL, "DROP TABLE [%s].[%s].[SQLExch_%s_%s_Trans]", sTrgDB, sDBO, sDB, sTable);
	lpCSQL->ExecuteNonQuery(sSQL);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationTables(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	WriteCon("CreateReplicationTables::");
	WriteCon(sTable);
	WriteCon("\n");

	char sSmlTmp[64];
	char sLargeSQL[10240];
	
	PRIMARY_KEYS MyPKs;

	if(GetPrimaryKeysEx(lpCSQL, sTable, &MyPKs))
	{
		int iKey = 0;

		sprintf(sLargeSQL, "CREATE TABLE [%s].[%s].[SQLExch_%s_%s_Trans] (\r\n", sTrgDB, sDBO, sDB, sTable);
		strcat(sLargeSQL, "\t[SQLExch_ID] Numeric NOT NULL IDENTITY(1, 1),\r\n");

		while(iKey < MyPKs.iPKs)
		{
			strcat(sLargeSQL, "\t[");
			strcat(sLargeSQL, MyPKs.sPKs[iKey]);
			strcat(sLargeSQL, "] ");

			strcat(sLargeSQL, MyPKs.sPKType[iKey]);

			if(MyPKs.iPKStatus[iKey] != 0)
			{
				sprintf(sSmlTmp, " (%d)", MyPKs.iPKLen[iKey]);
				strcat(sLargeSQL, sSmlTmp);
			}

			strcat(sLargeSQL, " NULL,\r\n");

			iKey++;
		}

		//-------------------------------------------------------------
		//Need to add a SQLExch_Pending Bit column to each of the new tables.
		//	We use this column because of the following scenario:
		//		
		//		1) When a transfer begins we need to update SQLExch_Pending = 1.
		//		2) Next we need to select all of the rows where SQLExch_Pending = 1.
		//		3) While the Server and client excange data, and do imports and exports,
		//			the data may have changed, adding more rows to the table with a
		//			SQLExch_Pending flag equal to 0
		//		4) If the impot was a success then we delete from the table where SQLExch_Pending = 1
		//		5) The rows that were added durring the server/client conversation are
		//			preserved for the next transfer
		//-------------------------------------------------------------
		strcat(sLargeSQL, "\t[Action] VarChar(10),\r\n");
		strcat(sLargeSQL, "\t[SQLExch_Pending] Bit\r\n");
		strcat(sLargeSQL, ") ON [PRIMARY]\r\n");

		lpCSQL->ExecuteNonQuery(sLargeSQL);

		FreePrimaryKeysEx(&MyPKs);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplicationTriggers(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	WriteCon("CreateReplicationTriggers\n");

	char sLargeBaseSQL[10240];
	char sLargeSQL[10240];

	PRIMARY_KEYS MyPKs;

	if(GetPrimaryKeysEx(lpCSQL, sTable, &MyPKs))
	{
		int iKey = 0;

		strcpy(sLargeSQL, "");
		while(iKey < MyPKs.iPKs)
		{
			strcat(sLargeSQL, "[");
			strcat(sLargeSQL, MyPKs.sPKs[iKey]);
			strcat(sLargeSQL, "] ");

			if(iKey != (MyPKs.iPKs - 1))
			{
				strcat(sLargeSQL, ",");
			}

			iKey++;
		}

		FreePrimaryKeysEx(&MyPKs);

		sprintf(sLargeBaseSQL, "CREATE TRIGGER [SQLExch_%s_%s_%%s_Trigger] ON [%s].[%s]\r\n"
			"\tFOR %%s\r\n"
			"\tAS\r\n"
			"\t\tINSERT INTO [%s].[%s].[SQLExch_%s_%s_Trans] (%s, Action)\r\n\t\t\tSELECT %s, '%%s' FROM %%s\r\n",
			sDB, sTable, sDBO, sTable,
			sTrgDB, sDBO, sDB, sTable, sLargeSQL, sLargeSQL);

		sprintf(sLargeSQL, sLargeBaseSQL, "Update", "INSERT, UPDATE", "Update", "Inserted");
		lpCSQL->ExecuteNonQuery(sLargeSQL);

		sprintf(sLargeSQL, sLargeBaseSQL, "Delete", "DELETE", "Delete", "Deleted");
		lpCSQL->ExecuteNonQuery(sLargeSQL);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//This function is complete!
bool CreateReplication(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO, char *sTable)
{
	WriteCon("CreateReplication\n");

	DropReplicationTriggers(lpCSQL, sDB, sTable);
	DropReplicationTables(lpCSQL, sTrgDB, sDB, sDBO, sTable);

	if(CreateReplicationTables(lpCSQL, sTrgDB, sDB, sDBO, sTable))
	{
		CreateReplicationTriggers(lpCSQL, sTrgDB, sDB, sDBO, sTable);
	}
	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GenerateReplicationScripts(CSQL *lpCSQL, char *sTrgDB, char *sDB, char *sDBO)
{
	WriteCon("GenerateReplicationScripts\n");

	char sSQL[10240];
	int iTempSz = 0;
	int iLen = 0;
	long lSeq = 1000;

	char sAction[100];

	FILE *hSource = NULL;

	char sOnSuccess[1024];
	char sOnFailure[1024];

	char sLargeBaseSQL[10240];
	char sLargeSQL[10240];
	char sTable[1024];
	char sTemp[1024];

	PRIMARY_KEYS MyPKs;

	CRecordSet rsTables;
	//CRecordSet rsColumns;

	//----------------------------------------------------------------------------------------------------
	//Create the "SQLExch_Statements" table
	//----------------------------------------------------------------------------------------------------
	sprintf(sLargeSQL, "%s\\SQL\\SQLExch_Statements.sql", gsPath);
	if((hSource = fopen(sLargeSQL, "rb")) == NULL)
	{
		MessageBox(MainDialog_hWnd, "Failed to open the SQLExch_Statements file.", gsTitleCaption, 0);
		return false;
	}

	iLen = Get_FileSize(sLargeSQL);
	fread(sLargeSQL, iLen, sizeof(char), hSource);
	sLargeSQL[iLen] = '\0';

	fclose(hSource);

	//Recreate the SQLExch_Statements table.
	lpCSQL->ExecuteNonQuery("DROP TABLE SQLExch_Statements"); 
	
	//Recreate the SQLExch_Statements table.
	lpCSQL->ExecuteNonQuery(sLargeSQL);

	//----------------------------------------------------------------------------------------------------

	//Create a record set containing all of the table names that contain SQLExch_ triggers
	strcpy(sSQL, "SELECT Name"
		" FROM SysObjects"
		" WHERE xType = 'U' AND (LEFT(NAME, 8) <> 'SQLExch_' AND"
		" ID IN (SELECT Parent_Obj FROM SysObjects AS A WHERE A.xType = 'TR' AND LEFT(A.NAME, 8) = 'SQLExch_'))"
		//" OR Name = 'SQLExch_Statements'"
		" ORDER BY Name");
	lpCSQL->Execute(sSQL, &rsTables);

	//Loop through all of the tables that have triggers.
	while(rsTables.Fetch())
	{
		//Get the table name, save it in sTable[]
		rsTables.sColumnEx(1, sTable, sizeof(sTable), &iTempSz);

		//Get a list of primary keys for the table.
		if(GetPrimaryKeysEx(lpCSQL, sTable, &MyPKs))
		{
			int iTrgTable = 0;

			//----------------------------------------------------------------------------------------
			//Insert the first statement into the "SQLExch_Statements" table.
			//----------------------------------------------------------------------------------------

			sprintf(sTemp, "UPDATE [%s].[%s].[SQLExch_%s_%s_Trans] SET SQLExch_Pending = 1",
				sTrgDB, sDBO, sDB, sTable, sTrgDB);

			sprintf(sSQL, "INSERT INTO SQLExch_Statements (Statement, OnSuccess, OnFailure, ImportTable,"
				" Sequence, Active, Comments, Identifier, Dirty)"
				" VALUES('%s', '%s', '%s', '%s', '%d', '1', 'Auto Generated.', 'SQLExch_Pending_Update_%d', 1)",
				sTemp, "NULL", "NULL", "NULL", lSeq, lSeq);
			lpCSQL->ExecuteNonQuery(sSQL);
			lSeq = (lSeq + 10);

			//----------------------------------------------------------------------------------------

			while(iTrgTable < 2)
			{
				int iKey = 0;

				strcpy(sLargeBaseSQL, "SELECT DISTINCT %s.*");
				strcat(sLargeBaseSQL, " FROM %s, [%s].[%s].[SQLExch_%s_%s_Trans]");
				strcat(sLargeBaseSQL, " WHERE ");

				//Loop through all of the primary keys
				while(iKey < MyPKs.iPKs)
				{
					strcat(sLargeBaseSQL, "[");
					strcat(sLargeBaseSQL, sTable);
					strcat(sLargeBaseSQL, "].");

					strcat(sLargeBaseSQL, "[");
					strcat(sLargeBaseSQL, MyPKs.sPKs[iKey]);
					strcat(sLargeBaseSQL, "] = ");

					strcat(sLargeBaseSQL, "[");
					strcat(sLargeBaseSQL, sTrgDB);
					strcat(sLargeBaseSQL, "].");

					strcat(sLargeBaseSQL, "[");
					strcat(sLargeBaseSQL, sDBO);
					strcat(sLargeBaseSQL, "].");

													
					strcat(sLargeBaseSQL, "[SQLExch_");
					strcat(sLargeBaseSQL, sDB);
					strcat(sLargeBaseSQL, "_");
					strcat(sLargeBaseSQL, sTable);
					strcat(sLargeBaseSQL, "_Trans].");

					strcat(sLargeBaseSQL, "[");
					strcat(sLargeBaseSQL, MyPKs.sPKs[iKey]);
					strcat(sLargeBaseSQL, "] AND ");

					iKey++;
				}

				if(iTrgTable == 0)      strcpy(sAction, "Update");
				else if(iTrgTable == 1) strcpy(sAction, "Delete");

				//----------------------------------------------------------------------------------------
				//Default sOnSuccess SQL.
				sprintf(sOnSuccess, "DELETE FROM [%s].[%s].[SQLExch_%s_%s_Trans] "
					" WHERE SQLExch_Pending = 1 AND [Action] = ''%s''",
					sTrgDB, sDBO, sDB, sTable, sAction);

				//No default OnFailure SQL.
				strcpy(sOnFailure, "");
				//----------------------------------------------------------------------------------------

				strcat(sLargeBaseSQL, "[%s].[%s].[SQLExch_%s_%s_Trans].SQLExch_Pending = 1 AND"
					" [%s].[%s].[SQLExch_%s_%s_Trans].[Action] = ''%s''");
				sprintf(sLargeSQL, sLargeBaseSQL, sTable, sTable, sTrgDB, sDBO, sDB, sTable,
					sTrgDB, sDBO, sDB, sTable,
					sTrgDB, sDBO, sDB, sTable, sAction);

				if(iTrgTable == 1)
				{
					strcat(sTable, "_SQLExch_Delete");
				}
				
				sprintf(sSQL, "INSERT INTO SQLExch_Statements (Statement, OnSuccess, OnFailure, ImportTable,"
					" Sequence, Active, Comments, Identifier, Dirty)"
					" VALUES('%s', '%s', '%s', '%s', '%d', '1', 'Auto Generated.', '%s', 1)",
					sLargeSQL, sOnSuccess, sOnFailure, sTable, lSeq, sAction);
				lpCSQL->ExecuteNonQuery(sSQL);
				lSeq = (lSeq + 10);

				iTrgTable++;
			}

			FreePrimaryKeysEx(&MyPKs);
		}
	}

	rsTables.Close();

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
